/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api.proto

package v2alpha1

import (
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// EncryptedObject is the representation of data stored in etcd after envelope encryption.
type EncryptedObject struct {
	// EncryptedData is the encrypted data.
	EncryptedData []byte `protobuf:"bytes,1,opt,name=encryptedData,proto3" json:"encryptedData,omitempty"`
	// KeyID is the KMS key ID used for encryption operations.
	KeyID string `protobuf:"bytes,2,opt,name=keyID,proto3" json:"keyID,omitempty"`
	// EncryptedDEK is the encrypted DEK.
	EncryptedDEK []byte `protobuf:"bytes,3,opt,name=encryptedDEK,proto3" json:"encryptedDEK,omitempty"`
	// Annotations is additional metadata that was provided by the KMS plugin.
	Annotations          map[string][]byte `protobuf:"bytes,4,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *EncryptedObject) Reset()         { *m = EncryptedObject{} }
func (m *EncryptedObject) String() string { return proto.CompactTextString(m) }
func (*EncryptedObject) ProtoMessage()    {}
func (*EncryptedObject) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{0}
}
func (m *EncryptedObject) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EncryptedObject.Unmarshal(m, b)
}
func (m *EncryptedObject) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EncryptedObject.Marshal(b, m, deterministic)
}
func (m *EncryptedObject) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EncryptedObject.Merge(m, src)
}
func (m *EncryptedObject) XXX_Size() int {
	return xxx_messageInfo_EncryptedObject.Size(m)
}
func (m *EncryptedObject) XXX_DiscardUnknown() {
	xxx_messageInfo_EncryptedObject.DiscardUnknown(m)
}

var xxx_messageInfo_EncryptedObject proto.InternalMessageInfo

func (m *EncryptedObject) GetEncryptedData() []byte {
	if m != nil {
		return m.EncryptedData
	}
	return nil
}

func (m *EncryptedObject) GetKeyID() string {
	if m != nil {
		return m.KeyID
	}
	return ""
}

func (m *EncryptedObject) GetEncryptedDEK() []byte {
	if m != nil {
		return m.EncryptedDEK
	}
	return nil
}

func (m *EncryptedObject) GetAnnotations() map[string][]byte {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func init() {
	proto.RegisterType((*EncryptedObject)(nil), "v2alpha1.EncryptedObject")
	proto.RegisterMapType((map[string][]byte)(nil), "v2alpha1.EncryptedObject.AnnotationsEntry")
}

func init() { proto.RegisterFile("api.proto", fileDescriptor_00212fb1f9d3bf1c) }

var fileDescriptor_00212fb1f9d3bf1c = []byte{
	// 252 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x5c, 0x90, 0xc1, 0x4b, 0xf3, 0x30,
	0x18, 0xc6, 0xe9, 0xfa, 0x7d, 0x62, 0xb3, 0x8a, 0x23, 0x78, 0x28, 0x9e, 0xca, 0xf0, 0x50, 0x3c,
	0x24, 0x58, 0x2f, 0xc3, 0x83, 0xe0, 0x68, 0x0f, 0xa2, 0x20, 0xe4, 0xe8, 0xed, 0xdd, 0x7c, 0x99,
	0x35, 0x35, 0x09, 0x49, 0x0c, 0xf4, 0xaf, 0x57, 0x96, 0x59, 0xe6, 0x76, 0xcb, 0xf3, 0xf0, 0x7b,
	0xe0, 0x97, 0x97, 0x64, 0x60, 0x3a, 0x66, 0xac, 0xf6, 0x9a, 0x9e, 0x86, 0x1a, 0x7a, 0xf3, 0x0e,
	0x37, 0xf3, 0xef, 0x84, 0x9c, 0xb7, 0x6a, 0x6d, 0x07, 0xe3, 0xf1, 0xed, 0x65, 0xf5, 0x81, 0x6b,
	0x4f, 0xaf, 0xc8, 0x19, 0x8e, 0x55, 0x03, 0x1e, 0x8a, 0xa4, 0x4c, 0xaa, 0x5c, 0x1c, 0x96, 0xf4,
	0x82, 0xfc, 0x97, 0x38, 0x3c, 0x36, 0xc5, 0xa4, 0x4c, 0xaa, 0x4c, 0xec, 0x02, 0x9d, 0x93, 0x7c,
	0x8f, 0xb5, 0x4f, 0x45, 0x1a, 0xa7, 0x07, 0x1d, 0x7d, 0x26, 0x53, 0x50, 0x4a, 0x7b, 0xf0, 0x9d,
	0x56, 0xae, 0xf8, 0x57, 0xa6, 0xd5, 0xb4, 0xbe, 0x66, 0xa3, 0x13, 0x3b, 0xf2, 0x61, 0x0f, 0x7b,
	0xb8, 0x55, 0xde, 0x0e, 0xe2, 0xef, 0xfc, 0xf2, 0x9e, 0xcc, 0x8e, 0x01, 0x3a, 0x23, 0xa9, 0xc4,
	0x21, 0x7a, 0x67, 0x62, 0xfb, 0xdc, 0xda, 0x06, 0xe8, 0xbf, 0x30, 0xda, 0xe6, 0x62, 0x17, 0xee,
	0x26, 0x8b, 0x64, 0xd9, 0xbc, 0x2e, 0xe5, 0xc2, 0xb1, 0x4e, 0x73, 0x30, 0x9d, 0x43, 0x1b, 0xd0,
	0x72, 0x23, 0x37, 0xdc, 0x79, 0x6d, 0x61, 0x83, 0x3c, 0x92, 0xfc, 0xf7, 0x03, 0x1c, 0x55, 0xc0,
	0x5e, 0x1b, 0xe4, 0xf2, 0xd3, 0x85, 0x9a, 0x8f, 0xce, 0xab, 0x93, 0x78, 0xd8, 0xdb, 0x9f, 0x00,
	0x00, 0x00, 0xff, 0xff, 0x37, 0xf9, 0x4d, 0xc2, 0x65, 0x01, 0x00, 0x00,
}
